/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.dialog.CommunicationSettingPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoXMLHandler;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.udf.UDFLibrary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogoXMLProperties
extends LogoXMLHandler {
    private static LogoXMLProperties fSingletonInstance = null;

    public static LogoXMLProperties getInstance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new LogoXMLProperties();
        }
        fSingletonInstance.refrehDocument();
        return fSingletonInstance;
    }

    @Override
    protected Document createDocument() {
        Document document = DocumentHelper.createDocument();
        document.addElement("properties");
        this.writeXML(document);
        return document;
    }

    @Override
    protected String getPath() {
        Version v = Version.getCurrentVersion();
        return System.getProperty("user.home", "") + "/." + v.getApplicationFileName() + v.getMajorVersion() + "." + v.getMinorVersion() + "/" + ".properties";
    }

    public void storeUDFLibrary(List<String> filePathList) {
        if (this.fDocument.getRootElement().element("udflibpath") != null) {
            this.fDocument.getRootElement().remove(this.fDocument.getRootElement().element("udflibpath"));
        }
        if (filePathList == null || filePathList.size() == 0) {
            this.writeXML(this.fDocument);
            return;
        }
        Element parent = this.fDocument.getRootElement().addElement("udflibpath");
        for (String filePath : filePathList) {
            Element pathElement = parent.addElement("udfpathentry");
            pathElement.addAttribute("path", filePath);
        }
        this.writeXML(this.fDocument);
    }

    public void storeIPAddress(Vector<CommunicationSettingPanel.IPConfig> ipConfigs, int selectionIndex) {
        if (this.fDocument.getRootElement().element("ipaddresses") != null) {
            this.fDocument.getRootElement().remove(this.fDocument.getRootElement().element("ipaddresses"));
        }
        if (ipConfigs == null || ipConfigs.size() == 0) {
            this.writeXML(this.fDocument);
            return;
        }
        Element parent = this.fDocument.getRootElement().addElement("ipaddresses");
        parent.addAttribute("selectedindex", String.valueOf(selectionIndex));
        for (CommunicationSettingPanel.IPConfig ipConfig : ipConfigs) {
            Element pathElement = parent.addElement("ipaddressentry");
            pathElement.addAttribute("name", ipConfig.values[0]);
            pathElement.addAttribute("ip", ipConfig.values[1]);
            pathElement.addAttribute("mask", ipConfig.values[2]);
            pathElement.addAttribute("gate", ipConfig.values[3]);
        }
        this.writeXML(this.fDocument);
    }

    public Vector<CommunicationSettingPanel.IPConfig> getIPAddress(int[] selectionIndex) {
        Vector<CommunicationSettingPanel.IPConfig> ipConfigs = new Vector<CommunicationSettingPanel.IPConfig>();
        Element ipAddressRoot = this.fDocument.getRootElement().element("ipaddresses");
        if (ipAddressRoot != null) {
            selectionIndex[0] = Integer.valueOf(ipAddressRoot.attributeValue("selectedindex"));
            Iterator ipaddressElements = ipAddressRoot.elementIterator("ipaddressentry");
            while (ipaddressElements.hasNext()) {
                CommunicationSettingPanel.IPConfig ipConfig = new CommunicationSettingPanel.IPConfig();
                Element ipaddress = (Element)ipaddressElements.next();
                ipConfig.values[0] = ipaddress.attributeValue("name");
                ipConfig.values[1] = ipaddress.attributeValue("ip");
                ipConfig.values[2] = ipaddress.attributeValue("mask");
                ipConfig.values[3] = ipaddress.attributeValue("gate");
                ipConfigs.add(ipConfig);
            }
        }
        return ipConfigs;
    }

    @Override
    protected Document readXML() {
        SAXReader reader = new SAXReader();
        this.fDocument = DocumentHelper.createDocument();
        try {
            this.fDocument = reader.read(this.getPath());
        }
        catch (Exception e) {
            try {
                this.fDocument = reader.read("file:///" + this.getPath());
            }
            catch (Exception ex) {
                this.fDocument = this.createDocument();
            }
        }
        return this.fDocument;
    }

    public List<String> getLibraryProperties(boolean getAllPaths) {
        ArrayList<String> pathList = new ArrayList<String>();
        if (this.fDocument.getRootElement().element("udflibpath") != null) {
            Iterator paths = this.fDocument.getRootElement().element("udflibpath").elementIterator("udfpathentry");
            while (paths.hasNext()) {
                String path = ((Element)paths.next()).attributeValue("path");
                if (!getAllPaths && this.isRepeat(pathList, path)) continue;
                pathList.add(path);
            }
        }
        return pathList;
    }

    public Vector getCityNameList() {
        if (this.fDocument.selectSingleNode("//CityList") == null) {
            this.createDefaultCityList();
        }
        Vector<String> cityList = new Vector<String>();
        cityList.add(Language.getString("dialog.parameter.astronomical.city.userDefined", "User defined"));
        List list = this.fDocument.selectNodes("//CityList//City");
        Iterator cityIterator = list.iterator();
        Element node = null;
        while (cityIterator.hasNext()) {
            node = (Element)cityIterator.next();
            cityList.add(node.valueOf("@Name"));
        }
        return cityList;
    }

    public Vector<String> getCityInfo(String name) {
        Vector<String> cityInfo = new Vector<String>(0);
        List list = this.fDocument.selectNodes("//CityList//City");
        Iterator cityIterator = list.iterator();
        Element node = null;
        while (cityIterator.hasNext()) {
            node = (Element)cityIterator.next();
            if (!name.equalsIgnoreCase(node.valueOf("@Name"))) continue;
            cityInfo.add(node.elementText("Longitude"));
            cityInfo.add(node.elementText("Latitude"));
            cityInfo.add(node.elementText("TimeZone"));
            break;
        }
        return cityInfo;
    }

    public boolean addCityInfo(String cityName, Vector<String> cityInfo) {
        Element tarCity = null;
        Element node2 = null;
        for (Element node2 : this.fDocument.selectNodes("//CityList//City")) {
            if (!node2.valueOf("@Name").equalsIgnoreCase(cityName)) continue;
            if (node2.attributeValue("Default") != null) {
                new LogoError(Language.getString("dialog.parameter.astronomical.city.nameExist", "This city name already exists.")).display();
                return false;
            }
            tarCity = node2;
        }
        Iterator<String> it = cityInfo.iterator();
        if (tarCity == null) {
            tarCity = ((Element)this.fDocument.selectSingleNode("//CityList")).addElement("City").addAttribute("Name", cityName);
            tarCity.addElement("Longitude").setText(it.next());
            tarCity.addElement("Latitude").setText(it.next());
            tarCity.addElement("TimeZone").setText(it.next());
        } else {
            tarCity.element("Longitude").setText(it.next());
            tarCity.element("Latitude").setText(it.next());
            tarCity.element("TimeZone").setText(it.next());
        }
        this.writeXML(this.fDocument);
        new LogoError(null, "wizard.modem.saveConfiguration.success", "Save successfully.", 1).display();
        return true;
    }

    public void removeCityInfo(String cityName) {
        List cityList = this.fDocument.selectNodes("//CityList//City");
        for (Element node : cityList) {
            if (!node.valueOf("@Name").equalsIgnoreCase(cityName)) continue;
            node.getParent().remove(node);
            this.writeXML(this.fDocument);
            return;
        }
    }

    private boolean isRepeat(List<String> paths, String newpath) {
        for (String path : paths) {
            if (path.equals(newpath)) {
                return true;
            }
            if (UDFLibrary.isFileIncluded(path, newpath)) {
                return true;
            }
            if (!UDFLibrary.isFileIncluded(newpath, path)) continue;
            paths.remove(path);
            return false;
        }
        return false;
    }

    public boolean isDefaultCity(String cityName) {
        List list = this.fDocument.selectNodes("//CityList//City");
        for (Element node : list) {
            if (!node.valueOf("@Default").equalsIgnoreCase("true") || !node.valueOf("@Name").equalsIgnoreCase(cityName)) continue;
            return true;
        }
        return false;
    }

    private void createDefaultCityList() {
        Element root = this.fDocument.getRootElement().addElement("CityList");
        Element node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.berlin", "Berlin")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E13\u00b024'41\"");
        node.addElement("Latitude").addText("N52\u00b031'24\"");
        node.addElement("TimeZone").addText("1");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.washington", "US - Washington")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("W77\u00b002'10\"");
        node.addElement("Latitude").addText("N38\u00b053'42\"");
        node.addElement("TimeZone").addText("-5");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.london", "UK - London")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("W0\u00b07'34\"");
        node.addElement("Latitude").addText("N51\u00b030'01\"");
        node.addElement("TimeZone").addText("0");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.paris", "Paris")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E2\u00b021'04\"");
        node.addElement("Latitude").addText("N48\u00b051'24\"");
        node.addElement("TimeZone").addText("1");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.moscow", "Moscow")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E37\u00b037'03\"");
        node.addElement("Latitude").addText("N55\u00b045'21\"");
        node.addElement("TimeZone").addText("3");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.amsterdam", "Amsterdam")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E4\u00b053'32\"");
        node.addElement("Latitude").addText("N52\u00b022'23\"");
        node.addElement("TimeZone").addText("1");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.beijing", "Beijing")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E116\u00b024'27\"");
        node.addElement("Latitude").addText("N39\u00b054'15\"");
        node.addElement("TimeZone").addText("8");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.tokyo", "Tokyo")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E139\u00b041'30\"");
        node.addElement("Latitude").addText("N35\u00b041'22\"");
        node.addElement("TimeZone").addText("9");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.ankara", "Ankara")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E32\u00b051'15\"");
        node.addElement("Latitude").addText("N39\u00b055'15\"");
        node.addElement("TimeZone").addText("2");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.rome", "Rome")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("E12\u00b028'56\"");
        node.addElement("Latitude").addText("N41\u00b053'44\"");
        node.addElement("TimeZone").addText("1");
        node = root.addElement("City");
        node.addAttribute("Name", Language.getString("dialog.parameter.astronomical.city.madrid", "Spain - Madrid")).addAttribute("Default", "true");
        node.addElement("Longitude").addText("W3\u00b042'01\"");
        node.addElement("Latitude").addText("N40\u00b025'00\"");
        node.addElement("TimeZone").addText("1");
        this.writeXML(this.fDocument);
    }
}

